/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.cards.blue;

import com.megacrit.cardcrawl.actions.AbstractGameAction;
import com.megacrit.cardcrawl.actions.common.DamageAction;
import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.cards.DamageInfo;
import com.megacrit.cardcrawl.characters.AbstractPlayer;
import com.megacrit.cardcrawl.core.AbstractCreature;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.localization.CardStrings;
import com.megacrit.cardcrawl.monsters.AbstractMonster;

public class Desperado
extends AbstractCard {
    public static final String ID = "Desperado";
    private static final CardStrings cardStrings = CardCrawlGame.languagePack.getCardStrings("Desperado");
    public static final String NAME = "Desperado";
    public static final String DESCRIPTION = "If you have no Ammo cards in your hand, deal !D! damage.";
    private static final int COST = 0;
    private static final int DAMAGE_AMT = 12;
    private static final int POOL = 1;

    public Desperado() {
        super("Desperado", "Desperado", null, 0, DESCRIPTION, AbstractCard.CardType.ATTACK, AbstractCard.CardColor.BLUE, AbstractCard.CardRarity.UNCOMMON, AbstractCard.CardTarget.ENEMY, 1);
        this.baseDamage = 12;
    }

    @Override
    public void use(AbstractPlayer p, AbstractMonster m) {
        int ammoCount = p.hand.getAmmo().size();
        if (ammoCount == 0) {
            AbstractDungeon.actionManager.addToBottom(new DamageAction((AbstractCreature)m, new DamageInfo(p, this.damage, this.damageTypeForTurn), AbstractGameAction.AttackEffect.FIRE));
        }
    }

    @Override
    public boolean canUse(AbstractPlayer p, AbstractMonster m) {
        int ammoCount = p.hand.getAmmo().size();
        this.cantUseMessage = "I still have ammo! NL (Should I be preventing this?)";
        return ammoCount == 0;
    }

    @Override
    public AbstractCard makeCopy() {
        return new Desperado();
    }

    @Override
    public void upgrade() {
        if (!this.upgraded) {
            this.upgradeName();
            this.upgradeDamage(4);
        }
    }
}

